local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// linked to
	self.LinkedClass = nil;
	
	// list layout.
	self.Layout = CtlListLayout_class:create( self );
	self.Layout:SetSpacing( 2 );
	
	// create the rotation gizmo.
	self.Rotation = CtlRotationElement_class:create( self.Layout:GetHandle() );
	self.Rotation:SetSize( 32, 32 );
	self.Layout:AddItem( self.Rotation );
	
	// create the translation gizmo.
	self.Translation = CtlTranslationElement_class:create( self.Layout:GetHandle() );
	self.Translation:SetSize( 32, 32 );
	self.Layout:AddItem( self.Translation );
	
	
	// create the header.
	self.FreezeHeader = CtlHeader_class:create( self.Layout:GetHandle() );
	self.FreezeHeader:SetPos( 4, 4 );
	self.FreezeHeader:SetSize( 128, 32 );
	self.FreezeHeader:SetTitle( "Freezing" );
	self.Layout:AddItem( self.FreezeHeader );
	
	// create unfreeze
	self.Unfreeze = CtlContextCheckBox_class:create( self.Layout:GetHandle() );
	self.Unfreeze:SetConVar( "vmf_spawn_unfrozen" );
	self.Unfreeze:SetText( "Unfreeze" );
	self.Unfreeze:SetSize( 32, 32 );
	self.Unfreeze:AddEvent( "OnValueChanged", "UnfreezeChecked", self );
	self.Layout:AddItem( self.Unfreeze );
	
	// create freeze
	self.Freeze = CtlContextCheckBox_class:create( self.Layout:GetHandle() );
	self.Freeze:SetConVar( "vmf_spawn_frozen" );
	self.Freeze:SetText( "Freeze" );
	self.Freeze:SetSize( 32, 32 );
	self.Freeze:AddEvent( "OnValueChanged", "FreezeChecked", self );
	self.Layout:AddItem( self.Freeze );
	
	
	
	// create the header.
	self.Header = CtlHeader_class:create( self.Layout:GetHandle() );
	self.Header:SetPos( 4, 4 );
	self.Header:SetSize( 128, 32 );
	self.Header:SetTitle( "Spawn Options" );
	self.Layout:AddItem( self.Header );
	
	// create weld
	self.Weld = CtlContextCheckBox_class:create( self.Layout:GetHandle() );
	self.Weld:SetConVar( "vmf_weld_surface" );
	self.Weld:SetText( "Weld" );
	self.Weld:SetSize( 32, 32 );
	self.Layout:AddItem( self.Weld );
	
	// create align
	self.Align = CtlContextCheckBox_class:create( self.Layout:GetHandle() );
	self.Align:SetConVar( "vmf_align_surface" );
	self.Align:SetText( "Surface Align" );
	self.Align:SetSize( 32, 32 );
	self.Layout:AddItem( self.Align );
	
end

// unfreeze was checked.
function PANEL:UnfreezeChecked( value )
	// checked?
	if( value && self.Freeze:GetChecked() ) then
		self.Freeze:SetChecked( false );
		
	end

end

// freeze was checked.
function PANEL:FreezeChecked( value )
	// checked?
	if( value && self.Unfreeze:GetChecked() ) then
		self.Unfreeze:SetChecked( false );
		
	end

end


// perform layout
function PANEL:PerformLayout( )
	// position the layout
	self.Layout:SetPos( 4, 4 );
	self.Layout:SetSize( self:GetWide() - 8, self:GetTall() - 8 );
	
	// update
	self.Layout:Update();

end


// draw
function PANEL:Paint( )
	// pain background.
	AppFramework:Theme():DrawFrame( 0, 0, self:GetWide(), self:GetTall(), FRAME_INSET );
	
	//
	return true;
	
end

// register
vgui.Register( "ctl_orientation_panel", PANEL, "Panel" );


// create app framework control.
CtlOrientationPanel_class 	= Control_class:create( nil, false, "ctl_orientation_panel" );
